/**
 * 
 */
package com.ejie.ab18a.utils;

import javax.servlet.http.HttpServletRequest;

import o75d.exe.O75API;
import o75d.exe.O75Peticion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.ab18a.properties.Ab18aPropertiesManager;

/**
 * @author XXXX
 * 
 */
public final class Ab18aO75Utils {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aO75Utils.class);

	private static final Integer TAM_BUFFER_50 = 50;

	private int nRet = 0;
	private long lNumeroPeticion = 0;
	private String sFechaPeticion = "";
	private long lErrorCodigo = 0;
	private String sErrorDescripcion = "";
	private int nErrorSQL = 0;
	private String sErrorMotivo = "";

	private Ab18aO75Utils() {
		super();
	}

	public static Ab18aO75Utils getInstance() {
		return (new Ab18aO75Utils());
	}

	// ========================================================
	// METODOS PARA REALIZAR PETICIONES A LA 075
	// ========================================================
	/**
	 * Lanzar proceso.
	 * 
	 * @param request
	 *            the request
	 * @param ficheroSH
	 *            the fichero sh
	 * @param sDescripcion
	 *            the s descripcion
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public String lanzarProceso(HttpServletRequest request, String ficheroSH, String sDescripcion) throws Exception {
		return this.lanzarProceso(request, ficheroSH, sDescripcion, null, null);
	}

	/**
	 * Lanzar proceso.
	 * 
	 * @param request
	 *            the request
	 * @param ficheroSH
	 *            the fichero sh
	 * @param sDescripcion
	 *            the s descripcion
	 * @param sParam1
	 *            the s param1
	 * @param sParam2
	 *            the s param2
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public String lanzarProceso(HttpServletRequest request, String ficheroSH, String sDescripcion, String sParam1, String sParam2) throws Exception {

		boolean exito = this.ab18aPeticionBatchTipoDirecto(request, ficheroSH, sDescripcion, sParam1, sParam2);

		if (exito) {
			return Constantes.CTE_TRUE;
		} else {
			return Constantes.CTE_FALSE;
		}
	}

	/**
	 * Lanzar proceso asignacion.
	 * 
	 * @param request
	 *            the request
	 * @param idioma
	 *            the idioma
	 * @param ficheroSH
	 *            the fichero sh
	 * @param sDescripcion
	 *            the s descripcion
	 * @param sParam1
	 *            the s param1
	 * @param sParam2
	 *            the s param2
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public String lanzarProcesoAsignacion(HttpServletRequest request, String idioma, String ficheroSH, String sDescripcion, String sParam1,
			String sParam2) throws Exception {
		boolean exito = this.ab18aPeticionBatchTipoDirecto(request, ficheroSH, sDescripcion, sParam1, sParam2);

		if (exito) {
			return Constantes.CTE_TRUE;
		} else {
			return Constantes.CTE_FALSE;
		}
	}

	// ====================================================================================================================

	/**
	 * ab18a peticion batch tipo directo.
	 * 
	 * @param request
	 *            the request
	 * @param sIdShell
	 *            the s id shell
	 * @param sDescripcion
	 *            the s descripcion
	 * @param sParam1
	 *            the s param1
	 * @param sParam2
	 *            the s param2
	 * @return true, if successful
	 * @throws Exception
	 *             the exception
	 */
	private boolean ab18aPeticionBatchTipoDirecto(HttpServletRequest request, String sIdShell, String sDescripcion, String sParam1, String sParam2)
			throws Exception {
		return this.ab18aPeticionBatch(request, sIdShell, sDescripcion, sParam1, sParam2, O75API.TIPO_DIRECTO);
	}

	// LLAMADAS A O75API \\
	/**
	 * ab18a peticion batch.
	 * 
	 * @param request
	 *            the request
	 * @param sIdShell
	 *            the s id shell
	 * @param sDescripcion
	 *            the s descripcion
	 * @param sParam1
	 *            the s param1
	 * @param param2
	 *            the param2
	 * @param sTipoProceso
	 *            the s tipo proceso
	 * @return true, if successful
	 * @throws Exception
	 *             the exception
	 */
	private boolean ab18aPeticionBatch(HttpServletRequest request, String sIdShell, String sDescripcion, String sParam1, String param2,
			String sTipoProceso) throws Exception {
		String parametro = sParam1;
		logger.debug("Comienza la peticion Batch...");
		boolean exito = false;

		// A�adir comillas simples por delante y por detras a cada parametro por
		// si tiene espacios en blanco,
		// porque esto hace que se parta en varios argumentos en la llamada al
		// sh
		if (null != parametro && parametro.indexOf("@@") != -1) {
			parametro.replaceAll(" ", "::");

			StringBuffer b = new StringBuffer(Ab18aO75Utils.TAM_BUFFER_50);
			String[] array = parametro.split("@@", -1);
			for (int i = 1; i < array.length - 1; i++) {
				b.append("@@");
				if (array[i] == null || "".equals(array[i].trim())) {
					b.append("null");
				} else {
					b.append(array[i]);
				}
			}
			b.append("@@");
			parametro = b.toString();

		}

		String sApp = Ab18aPropertiesManager.getProperty("COD_APLICACION");
		String sBuzon = Ab18aPropertiesManager.getProperty("batch.buzonCargaFicheroPru");

		// O75API o75api = new O75API(request);

		O75API o75api = new O75API(Ab18aXLNETSUtils.getSessionToken(sApp));
		O75Peticion o75peticion = new O75Peticion();
		o75peticion.SetBuzon(sBuzon);
		logger.debug("Buzon: " + sBuzon);
		o75peticion.SetAplicacion(sApp);
		logger.debug("Aplicación: " + sApp);
		o75peticion.SetRuntime(O75API.RUNTIME_SH);
		logger.debug("Runtime: " + O75API.RUNTIME_SH);
		logger.debug("ab18aPeticionBatch: SH a lanzar en la O75: " + sIdShell);
		logger.debug("ab18aPeticionBatch: Parametros del SH a lanzar en la O75: " + parametro);

		o75peticion.SetIdShell(sIdShell);
		logger.debug("Shell: " + sIdShell);
		if (parametro != null) {
			o75peticion.SetParam1(parametro);
		}

		if (param2 != null) {
			o75peticion.SetParam2(param2);
		}

		o75peticion.SetDescripcion(sDescripcion);
		logger.debug("Descripción: " + sDescripcion);

		o75peticion.SetTipoPeticion(O75API.TIPOPET_ROLTIPO);
		logger.debug("Tipo Petición: " + O75API.TIPOPET_ROLTIPO);
		// o75peticion.SetPropietario("Login app");
		o75peticion.SetPropietario(Ab18aPropertiesManager.getProperty("o75.propietario"));
		logger.debug("Propietario: " + o75peticion.GetPropietario());

		if ((null != sTipoProceso) && (sTipoProceso.equals("batch"))) {
			o75peticion.SetTipo(O75API.TIPO_BATCH);
		} else {
			o75peticion.SetTipo(O75API.TIPO_DIRECTO);
		}
		logger.debug("Tipo Proceso: " + o75peticion.GetTipo());
		o75peticion.SetSubtipo(O75API.SUBTIPO_RELANZABLE);
		logger.debug("Subtipo Proceso: " + O75API.SUBTIPO_RELANZABLE);

		logger.debug("ab18aPeticionBatch: o75peticion: '" + o75peticion.GetValores() + "'");

		int nRet = o75api.Alta(o75peticion);

		logger.debug("ab18aPeticionBatch: Realizada peticion a la O75. Resultado: '" + nRet + "'");

		if (nRet == 0) {
			exito = true;
		}

		if (exito) {
			this.lNumeroPeticion = o75peticion.GetNumeroPeticion();
			this.sFechaPeticion = o75peticion.GetFechaPeticion();
		} else {
			this.lErrorCodigo = o75api.GetCodigoError();
			this.sErrorDescripcion = o75api.GetDec();
			this.nErrorSQL = o75api.GetCodigoErrorSQL();
			this.sErrorMotivo = o75api.GetMotivo();

			logger.error("ab18aPeticionBatch: error al ejecutar la peticion:" + o75peticion.GetValores());
			logger.error("ab18aPeticionBatch: error al ejecutar la peticion GetXMLValores:" + o75peticion.GetXMLValores());
			logger.error("ab18aPeticionBatch: error al ejecutar la peticion GetXML:" + o75peticion.GetXML());
		}
		this.logPeticion(exito);

		logger.debug("ab18aPeticionBatch: Fin de ab18aPeticionBatch(). Resultado: '" + exito + "'");

		return exito;
	}

	/**
	 * Log peticion.
	 * 
	 * @param exito
	 *            the exito
	 */
	public void logPeticion(boolean exito) {
		if (exito) {
			logger.debug("ab18aPeticionBatch: lNumeroPeticion:" + this.getlNumeroPeticion());
			logger.debug("ab18aPeticionBatch: sFechaPeticion:" + this.getsFechaPeticion());
		} else {
			logger.error("ab18aPeticionBatch: lErrorCodigo:" + this.getlErrorCodigo());
			logger.error("ab18aPeticionBatch: sErrorDescripcion:" + this.getsErrorDescripcion());
			logger.error("ab18aPeticionBatch: nErrorSQL:" + this.getnErrorSQL());
			logger.error("ab18aPeticionBatch: sErrorMotivo:" + this.getsErrorMotivo());
		}
	}

	public int getnRet() {
		return nRet;
	}

	public void setnRet(int nRet) {
		this.nRet = nRet;
	}

	public long getlNumeroPeticion() {
		return lNumeroPeticion;
	}

	public void setlNumeroPeticion(long lNumeroPeticion) {
		this.lNumeroPeticion = lNumeroPeticion;
	}

	public String getsFechaPeticion() {
		return sFechaPeticion;
	}

	public void setsFechaPeticion(String sFechaPeticion) {
		this.sFechaPeticion = sFechaPeticion;
	}

	public long getlErrorCodigo() {
		return lErrorCodigo;
	}

	public void setlErrorCodigo(long lErrorCodigo) {
		this.lErrorCodigo = lErrorCodigo;
	}

	public String getsErrorDescripcion() {
		return sErrorDescripcion;
	}

	public void setsErrorDescripcion(String sErrorDescripcion) {
		this.sErrorDescripcion = sErrorDescripcion;
	}

	public int getnErrorSQL() {
		return nErrorSQL;
	}

	public void setnErrorSQL(int nErrorSQL) {
		this.nErrorSQL = nErrorSQL;
	}

	public String getsErrorMotivo() {
		return sErrorMotivo;
	}

	public void setsErrorMotivo(String sErrorMotivo) {
		this.sErrorMotivo = sErrorMotivo;
	}
}
